/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.spawn.entity.Snail;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailModel
extends EntityModel<Snail> {
    private static final String FOOT = "foot";
    private static final String WHISKERS = "whiskers";
    private static final String SHELL = "shell";
    private final ModelPart shell;
    private final ModelPart foot;
    private final ModelPart whiskers;
    private final ModelPart leftEye;
    private final ModelPart rightEye;

    public SnailModel(ModelPart root) {
        this.shell = root.m_171324_(SHELL);
        this.foot = root.m_171324_(FOOT);
        this.whiskers = this.foot.m_171324_(WHISKERS);
        this.leftEye = this.foot.m_171324_("left_eye");
        this.rightEye = this.foot.m_171324_("right_eye");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition shell = modelPartData.m_171599_(SHELL, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -7.0f, 0.0f, 10.0f, 10.0f, 10.0f).m_171514_(0, 20).m_171481_(-4.0f, -2.0f, -2.0f, 8.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-1.0f));
        PartDefinition foot = modelPartData.m_171599_(FOOT, CubeListBuilder.m_171558_().m_171514_(28, 8).m_171481_(-3.0f, -5.0f, -6.0f, 6.0f, 5.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition whiskers = foot.m_171599_(WHISKERS, CubeListBuilder.m_171558_().m_171514_(8, 24).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 0.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-6.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = foot.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(12, 26).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f).m_171514_(0, 24).m_171481_(-1.5f, -6.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)2.0f, (float)-5.0f, (float)-4.5f));
        PartDefinition rightEye = foot.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(12, 26).m_171480_().m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f).m_171555_(false).m_171514_(0, 24).m_171480_().m_171481_(-1.5f, -6.0f, -1.5f, 3.0f, 3.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-5.0f, (float)-4.5f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    public void setupAnim(Snail entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        float speed = 1.0f;
        float degree = 1.0f;
        float tilt = Math.min(limbSwingAmount * 2.0f, 0.5f);
        this.shell.f_104207_ = entity.getShellGrowthTicks() == 0;
        this.leftEye.f_104203_ = headPitch * pi / 180.0f;
        this.leftEye.f_104204_ = headYaw * pi / 180.0f;
        this.rightEye.f_104203_ = headPitch * pi / 180.0f;
        this.rightEye.f_104204_ = headYaw * pi / 180.0f;
        this.leftEye.f_104205_ = Mth.m_14031_((float)(ageInTicks * speed * 0.05f)) * degree * 0.1f;
        this.leftEye.f_104203_ += Mth.m_14089_((float)(ageInTicks * speed * 0.025f)) * degree * 0.2f;
        this.leftEye.f_104201_ = Mth.m_14089_((float)(ageInTicks * speed * 0.025f + pi / 2.0f)) * degree - 5.0f;
        this.rightEye.f_104205_ = Mth.m_14031_((float)(ageInTicks * speed * 0.05f + pi)) * degree * 0.1f;
        this.rightEye.f_104203_ += Mth.m_14089_((float)(ageInTicks * speed * 0.025f + pi)) * degree * 0.2f;
        this.rightEye.f_104201_ = Mth.m_14089_((float)(ageInTicks * speed * 0.025f - pi / 2.0f)) * degree - 5.0f;
        this.foot.f_233555_ = 1.0f + tilt;
        this.leftEye.f_233555_ = 1.0f - tilt;
        this.rightEye.f_233555_ = 1.0f - tilt;
        this.whiskers.f_104203_ = Mth.m_14031_((float)(ageInTicks * speed * 0.05f + pi / 2.0f)) * degree * 0.5f + pi / 4.0f;
        if (entity.isScared()) {
            this.foot.f_104207_ = false;
            this.shell.f_104201_ = entity.m_6162_() ? 23.0f : 21.0f;
            this.shell.f_104202_ = -4.0f;
            this.shell.f_104205_ = 0.0f;
        } else {
            this.shell.f_104205_ = Mth.m_14031_((float)(limbSwing * speed * 0.6f)) * degree * -0.5f * limbSwingAmount;
            this.foot.f_104207_ = true;
            this.shell.f_104201_ = 19.0f;
            this.shell.f_104202_ = -1.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 1.0, 0.05);
            poseStack.m_85841_(0.31f, 0.31f, 0.31f);
            this.shell.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85837_(0.0, 1.5, 0.0);
            this.foot.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
            poseStack.m_85849_();
        } else {
            this.shell.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
            this.foot.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }
}

